﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderMap
    {
        public static async Task<IQueryable<Provider>> MapProviders(List<Account> ppmsProviders, string mapRelatedType, PpmsContext context)
        {
            var providerList = new List<Provider> { };
            foreach (var ppmsProvider in ppmsProviders)
            {

                var provider = new Provider
                {
                                       
                    ProviderIdentifier = ppmsProvider.ppms_ProviderIdentifier,
                    Name = ppmsProvider.Name,
                    MainPhone = ppmsProvider.Telephone1,
                    Email = ppmsProvider.EMailAddress1,
                    Address = ppmsProvider.Address1_Composite,
                    AddressCity = ppmsProvider.Address1_City,
                    AddressStreet = ppmsProvider.Address1_Line1,
                    AddressStateProvince = ppmsProvider.Address1_StateOrProvince,
                    AddressCounty = ppmsProvider.Address1_County,
                    AddressPostalCode = ppmsProvider.Address1_PostalCode,
                    AddressCountry = ppmsProvider.Address1_Country 
                };

                //Provider Identifier Type
                if (ppmsProvider.ppms_ProviderIdentifierType != null)
                    switch (ppmsProvider.ppms_ProviderIdentifierType.Value)
                    {
                        case (int)ppms_ProviderIdentifierType.NPI:
                            provider.ProviderIdentifierType = ProviderIdentifierType.Npi;
                            break;
                        case (int)ppms_ProviderIdentifierType.TaxIdentificationNumber:
                            provider.ProviderIdentifierType = ProviderIdentifierType.TaxIdentificationNumber;
                            break;
                    }


                if (ppmsProvider.ModifiedOn != null)
                {
                    provider.ModifiedOnDate = ppmsProvider.ModifiedOn.Value;
                }


                if (ppmsProvider.ppms_qualityrankinglastupdated != null)
                {
                    provider.QualityRankingLastUpdated = ppmsProvider.ppms_qualityrankinglastupdated.ToString();
                }
                if (ppmsProvider.ppms_qualityrankingtotalscore != null)
                {
                    provider.QualityRankingTotalScore = (int)ppmsProvider.ppms_qualityrankingtotalscore;
                }

                //Provider Type Switch. 
                if (ppmsProvider.ppms_providertype != null)
                    switch (ppmsProvider.ppms_providertype.Value)
                    {
                        case (int)Account_ppms_providertype.Individual:
                            provider.ProviderType = ProviderType.Individual;

                            //Invidual Attribute Mappings

                            //Religion
                            provider.Religion = ppmsProvider.ppms_religion;

                            //Accepting New Patients 
                            if (ppmsProvider.ppms_individualisacceptingnewpatients != null)
                                switch (ppmsProvider.ppms_individualisacceptingnewpatients.Value)
                                {
                                    case true:
                                        provider.IsAcceptingNewPatients = true;
                                        break;
                                    case false:
                                        provider.IsAcceptingNewPatients = false;
                                        break;
                                }

                            //Ethnicity Switch
                            if (ppmsProvider.ppms_ethnicity != null)
                                switch (ppmsProvider.ppms_ethnicity.Value)
                                {
                                    case (int)Account_ppms_ethnicity.DeclinetoAnswer:
                                        provider.ProviderEthnicity = ProviderEthnicity.DeclineToAnswer;
                                        break;
                                    case (int)Account_ppms_ethnicity.HispanicorLatino:
                                        provider.ProviderEthnicity = ProviderEthnicity.HispanicOrLatino;
                                        break;
                                    case (int)Account_ppms_ethnicity.NotHispanicorLatino:
                                        provider.ProviderEthnicity = ProviderEthnicity.NotHispanicOrLatino;
                                        break;
                                    case (int)Account_ppms_ethnicity.Unknown:
                                        provider.ProviderEthnicity = ProviderEthnicity.Unknown;
                                        break;
                                }

                            //Gender
                            if (ppmsProvider.ppms_gender != null)
                                switch (ppmsProvider.ppms_gender.Value)
                                {
                                    case (int)ppms_Gender.Male:
                                        provider.ProviderGender = ProviderGender.Male;
                                        break;
                                    case (int)ppms_Gender.Female:
                                        provider.ProviderGender = ProviderGender.Female;
                                        break;
                                    case (int)ppms_Gender.NotSpecified:
                                        provider.ProviderGender = ProviderGender.NotSpecified;
                                        break;
                                    case (int)ppms_Gender.Other:
                                        provider.ProviderGender = ProviderGender.Other;
                                        break;
                                }

                            //Individual Internal/External Switch
                            if (ppmsProvider.ppms_isexternal != null)
                                switch (ppmsProvider.ppms_isexternal.Value)
                                {
                                    case true:
                                        provider.IsExternal = true;
                                        //External Attribute mappings

                                        provider.ValidationSource = ppmsProvider.ppms_externalvalidationsource;
                                        provider.ExternalInstitutionDeaNumber =
                                            ppmsProvider.ppms_externalinstitutiondeanumber;
                                        if (ppmsProvider.ppms_externalleiecheckdate != null)
                                        {
                                            provider.ExternalLeieCheckDate =
                                                ppmsProvider.ppms_externalleiecheckdate.ToString();
                                        }

                                        //On LEIE switch
                                        //Field Removed
                                        /*
                                        if (ppmsProvider.ppms_externalnotonleie != null)
                                            switch (ppmsProvider.ppms_externalnotonleie.Value)
                                            {
                                                case true:
                                                    provider.OnLeie = true;
                                                    break;
                                                case false:
                                                    provider.OnLeie = false;
                                                    break;
                                            }
*                                       */

                                        //Health Provider Type Switch
                                        if (ppmsProvider.ppms_externalhealthprovidertype != null)
                                            switch (ppmsProvider.ppms_externalhealthprovidertype.Value)
                                            {
                                                case (int)Account_ppms_externalhealthprovidertype.CommunityHospital:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.CommunityHospital;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.CommunityService:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.CommunityService;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.ExternalLaboratory:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.ExternalLaboratory;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.ExternalSupportGroup:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.ExternalSupportGroup;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.HomeHealthCare:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.HomeHealthCare;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.Radiology:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.Radiology;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.Rehabilitation:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.Rehabilitation;
                                                    break;
                                                case (int)Account_ppms_externalhealthprovidertype.Services:
                                                    provider.ExternalHealthProviderType = ExternalHealthProviderType.Services;
                                                    break;

                                            }

                                        break;
                                    case false:
                                        provider.IsExternal = false;
                                        //Internal Attribute mappings
                                        provider.LicensingJuristicion = ppmsProvider.ppms_internallicensingjurisdiction;

                                        //Can Create health care orders swtich
                                        if (ppmsProvider.ppms_internalcancreatehealthcareorders != null)
                                            switch (ppmsProvider.ppms_internalcancreatehealthcareorders.Value)
                                            {
                                                case true:
                                                    provider.CanCreateHealthCareOrders = true;
                                                    break;
                                                case false:
                                                    provider.CanCreateHealthCareOrders = false;
                                                    break;
                                            }

                                        if (ppmsProvider.ppms_internalappointmentstatus != null)
                                            switch (ppmsProvider.ppms_internalappointmentstatus.Value)
                                            {
                                                case (int)Account_ppms_internalappointmentstatus.Consulting:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.Consulting;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.Other:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.Other;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.FeeBasisOnStation:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.FeeBasisOnStation;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.FullTime:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.FullTime;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.PartTime:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.PartTime;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.Resident:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.Resident;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.SpecialtyFellow:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.SpecialityFellow;
                                                    break;
                                                case (int)Account_ppms_internalappointmentstatus.WOC:
                                                    provider.InternalAppointmentStatus = InternalAppointmentStatus.WOC;
                                                    break;

                                            }

                                        //Internal Type Swich
                                        //There are currently no Internal Type values defined.
                                        /*
                                        if (ppmsProvider.ppms_internaltype != null)
                                            switch (ppmsProvider.ppms_internaltype.Value)
                                            {
                                                case (int)Account_ppms_internaltype.:
                                                    provider.InternalType = InternalType.;
                                                    break;
                                                case (int)Account_ppms_internaltype.:
                                                    provider.InternalType = InternalType.;
                                                    break;
                                                
                                            }
                                            */

                                        break;

                                }


                            break;

                        case (int)Account_ppms_providertype.GroupPracticeAgency:
                            provider.ProviderType = ProviderType.GroupPracticeOrAgency;

                            //Group Org Attribute Mappings
                            provider.OrganizationId = ppmsProvider.ppms_organizationid;
                            provider.SpecialInstruction = ppmsProvider.ppms_specialinstruction;
                            provider.OrganizationFax = ppmsProvider.Fax;

                            if (ppmsProvider.ppms_serviceprovidertype != null)
                                switch (ppmsProvider.ppms_serviceprovidertype.Value)
                                {
                                    case (int)Account_ppms_serviceprovidertype.Clinic:
                                        provider.ServiceProviderType = ServiceProviderType.Clinic;
                                        break;
                                    case (int)Account_ppms_serviceprovidertype.Lab:
                                        provider.ServiceProviderType = ServiceProviderType.Lab;
                                        break;
                                    case (int)Account_ppms_serviceprovidertype.RadiologyServices:
                                        provider.ServiceProviderType = ServiceProviderType.RadiologyServices;
                                        break;
                                    case (int)Account_ppms_serviceprovidertype.Research:
                                        provider.ServiceProviderType = ServiceProviderType.Research;
                                        break;
                                    case (int)Account_ppms_serviceprovidertype.Transportation:
                                        provider.ServiceProviderType = ServiceProviderType.Transportation;
                                        break;

                                }

                            //Map the owned care site name. 
                            if (ppmsProvider.ppms_ownedcaresite != null)
                                provider.OwnedCareSiteName = ppmsProvider.ppms_ownedcaresite.Name;

                            //Org Status
                            if (ppmsProvider.ppms_statusorg != null)
                                switch (ppmsProvider.ppms_statusorg.Value)
                                {
                                    case (int)new_ActiveInactiveList.Active:
                                        provider.OrganizationStatus = OrganizationStatus.Active;
                                        break;
                                    case (int)new_ActiveInactiveList.Inactive:
                                        provider.OrganizationStatus = OrganizationStatus.Inactive;
                                        break;
                                }
                            break;
                    }

                if (ppmsProvider.StatusCode != null)
                    switch (ppmsProvider.StatusCode.Value)
                    {
                        case (int)Account_StatusCode.Active:
                            provider.ProviderStatusReason = ProviderStatusReason.Active;
                            break;
                        case (int)Account_StatusCode.AddressValidation:
                            provider.ProviderStatusReason = ProviderStatusReason.AddressValidation;
                            break;
                        case (int)Account_StatusCode.Deactivated:
                            provider.ProviderStatusReason = ProviderStatusReason.Deactivated;
                            break;
                        case (int)Account_StatusCode.Hold:
                            provider.ProviderStatusReason = ProviderStatusReason.Hold;
                            break;
                        case (int)Account_StatusCode.Inactive:
                            provider.ProviderStatusReason = ProviderStatusReason.Inactive;
                            break;
                        case (int)Account_StatusCode.LEIEExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.LeieExclusion;
                            break;
                        case (int)Account_StatusCode.LicenseExpiration:
                            provider.ProviderStatusReason = ProviderStatusReason.LicenseExpiration;
                            break;
                        case (int)Account_StatusCode.NPICheckFailure:
                            provider.ProviderStatusReason = ProviderStatusReason.NpiCheckFailure;
                            break;
                        case (int)Account_StatusCode.PendingReview:
                            provider.ProviderStatusReason = ProviderStatusReason.PendingReview;
                            break;
                        case (int)Account_StatusCode.SAMSExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.SamsExclusion;
                            break;
                        case (int)Account_StatusCode.ValidationProcess:
                            provider.ProviderStatusReason = ProviderStatusReason.ValidationProcess;
                            break;

                    }


                if (ppmsProvider.ppms_PrimaryCarePhysician != null)
                    switch (ppmsProvider.ppms_PrimaryCarePhysician.Value)
                    {
                        case true:
                            provider.PrimaryCarePhysician = true;
                            break;
                        case false:
                            provider.PrimaryCarePhysician = false;
                            break;
                    }
               
                if (ppmsProvider.ppms_HighPerformance != null)
                    switch (ppmsProvider.ppms_HighPerformance.Value)
                    {
                        case true:
                            provider.HighPerformance = true;
                            break;
                        case false:
                            provider.HighPerformance = false;
                            break;
                    }

                if (ppmsProvider.ppms_FQHC != null)
                    switch (ppmsProvider.ppms_FQHC.Value)
                    {
                        case true:
                            provider.Fqhc = true;
                            break;
                        case false:
                            provider.Fqhc = false;
                            break;
                    }

                if (ppmsProvider.ppms_ACO != null)
                    switch (ppmsProvider.ppms_ACO.Value)
                    {
                        case true:
                            provider.AccountableCareOrganization = true;
                            break;
                        case false:
                            provider.AccountableCareOrganization = false;
                            break;
                    }

                //Contact Preferences
                if (ppmsProvider.PreferredContactMethodCode != null)
                    switch (ppmsProvider.PreferredContactMethodCode.Value)
                    {
                        case (int)Account_PreferredContactMethodCode.Email:
                            provider.ContactMethod = PreferredMethodOfContact.Email;
                            break;
                        case (int)Account_PreferredContactMethodCode.Any:
                            provider.ContactMethod = PreferredMethodOfContact.Any;
                            break;
                        case (int)Account_PreferredContactMethodCode.Fax:
                            provider.ContactMethod = PreferredMethodOfContact.Fax;
                            break;
                        case (int)Account_PreferredContactMethodCode.Mail:
                            provider.ContactMethod = PreferredMethodOfContact.Mail;
                            break;
                        case (int)Account_PreferredContactMethodCode.Phone:
                            provider.ContactMethod = PreferredMethodOfContact.Phone;
                            break;
                    }

                //Bulk Emailed allowed? 
                if (ppmsProvider.DoNotBulkEMail != null)
                    switch (ppmsProvider.DoNotBulkEMail.Value)
                    {
                        case true:
                            provider.BulkEmails = false;
                            break;
                        case false:
                            provider.BulkEmails = true;
                            break;
                    }

                //Bulk Mail allowed? 
                if (ppmsProvider.DoNotBulkPostalMail != null)
                    switch (ppmsProvider.DoNotBulkPostalMail.Value)
                    {
                        case true:
                            provider.BulkMails = false;
                            break;
                        case false:
                            provider.BulkMails = true;
                            break;
                    }

                //Email allowed? 
                if (ppmsProvider.DoNotEMail != null)
                    switch (ppmsProvider.DoNotEMail.Value)
                    {
                        case true:
                            provider.Emails = false;
                            break;
                        case false:
                            provider.Emails = true;
                            break;
                    }

                //Mail allowed?
                if (ppmsProvider.DoNotPostalMail != null)
                    switch (ppmsProvider.DoNotPostalMail.Value)
                    {
                        case true:
                            provider.Mails = false;
                            break;
                        case false:
                            provider.Mails = true;
                            break;
                    }

                //Phone allowed?
                if (ppmsProvider.DoNotPhone != null)
                    switch (ppmsProvider.DoNotPhone.Value)
                    {
                        case true:
                            provider.PhoneCalls = false;
                            break;
                        case false:
                            provider.PhoneCalls = true;
                            break;
                    }

                //Faxes allowed? 
                if (ppmsProvider.DoNotFax != null)
                    switch (ppmsProvider.DoNotFax.Value)
                    {
                        case true:
                            provider.Faxes = false;
                            break;
                        case false:
                            provider.Faxes = true;
                            break;
                    }

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=ProviderSpecialties"))
                    mapRelatedType = "ProviderSpecialties";
                if (mapRelatedType.Contains("?$expand=ProviderCredentials"))
                    mapRelatedType = "ProviderCredentials";
                if (mapRelatedType.Contains("?$expand=ProviderContacts"))
                    mapRelatedType = "ProviderContacts";
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=ProviderIdentifiers"))
                    mapRelatedType = "ProviderIdentifiers";
                if (mapRelatedType.Contains("?$expand=ProviderLicenses"))
                    mapRelatedType = "ProviderLicenses";
                if (mapRelatedType.Contains("?$expand=ProviderPrivileges"))
                    mapRelatedType = "ProviderPrivileges";
                if (mapRelatedType.Contains("?$expand=CareSites"))
                    mapRelatedType = "CareSites";
                if (mapRelatedType.Contains("?$expand=DEAs"))
                    mapRelatedType = "DEAs";
                if (mapRelatedType.Contains("?$expand=VaProviderRelationships"))
                    mapRelatedType = "VaProviderRelationships";
                if (mapRelatedType.Contains("?$expand=OwnedCareSite"))
                    mapRelatedType = "OwnedCareSite";
                if (mapRelatedType.Contains("?$expand=OwningOrganization"))
                    mapRelatedType = "OwningOrganization";
                if (mapRelatedType.Contains("?$expand=Providers"))
                    mapRelatedType = "Providers";

                switch (mapRelatedType)
                {
                    case "ProviderSpecialties":
                        //Lookup and Map the Provider Specialties
                        var ppmsProviderSpecialties =
                            context.ppms_providertaxonomySet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                        provider.ProviderSpecialties =
                            await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, "None",
                                context);
                        break;
                    case "ProviderCredentials":
                        //Lookup and Map the Provider Credentials
                        var ppmsProviderCredentials =
                            context.ppms_providercredentialSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsProviderCredentialsList = ppmsProviderCredentials.ToList();
                        provider.ProviderCredentials =
                            await ProviderCredentialsMap.MapProviderCredentials(ppmsProviderCredentialsList, "None",
                                context);
                        break;
                    case "ProviderContacts":
                        //Lookup and Map the Provider Contacts
                        var ppmsProviderContacts =
                            context.ContactSet.Where(i => i.ParentCustomerId.Id == ppmsProvider.Id);
                        var ppmsProviderContactsList = ppmsProviderContacts.ToList();
                        provider.ProviderContacts =
                            await ProviderContactsMap.MapProviderContacts(ppmsProviderContactsList, "None", context);
                        break;
                    case "ProviderServices":
                        //Lookup and Map the Provider Services
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        provider.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;
                    case "ProviderIdentifiers":
                        //Lookup and Map the Provider Npis
                        var ppmsProvideridentifiers =
                            context.ppms_provideridentifierSet.Where(i => i.ppms_Provider.Id == ppmsProvider.Id);
                        var ppmsProviderIdentifiersList = ppmsProvideridentifiers.ToList();
                        provider.ProviderIdentifiers =
                            await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsProviderIdentifiersList, "None", context);
                        break;
                    case "ProviderLicenses":
                        //Lookup and Map the Provider Licenses
                        var ppmsProviderLicenses =
                            context.ppms_providerlicensureSet.Where(i => i.ppms_ProviderIdId.Id == ppmsProvider.Id);
                        var ppmsProviderLicensesList = ppmsProviderLicenses.ToList();
                        provider.ProviderLicenses =
                            await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, "None", context);
                        break;
                    case "ProviderPrivileges":
                        //Lookup and Map the Provider Privileges
                        var ppmsProviderPrivileges =
                            context.ppms_providerprivilegeSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                        provider.ProviderPrivileges =
                            await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None",
                                context);
                        break;
                    case "OwnedCareSite":
                        //Lookup and Map the Provider Privileges
                        //Only Organizations will have an owned care site
                        if (ppmsProvider?.ppms_providertype?.Value ==
                            (int)Account_ppms_providertype.GroupPracticeAgency)
                        {
                            var ppmsOwnedCareSite =
                                context.ppms_caresiteSet.FirstOrDefault(
                                    i => i.Id == ppmsProvider.ppms_ownedcaresite.Id);
                            var ppmsOwnedCareSiteList = new List<ppms_caresite> { ppmsOwnedCareSite };
                            provider.OwnedCareSite =
                                await CareSiteMap.MapCareSites(ppmsOwnedCareSiteList, "None", context);
                        }
                        break;
                    case "OwningOrganization":
                        //Look up and Map Owning Organization
                            var ppmsOwningOrg =
                                context.AccountSet.FirstOrDefault(
                                    i => i.Id == ppmsProvider.ParentAccountId.Id);
                            var ppmsOwningOrgList = new List<Account> { ppmsOwningOrg };
                        //Map Owning Org
                        provider.OwningOrganization =
                                await ProviderMap.MapProviders(ppmsOwningOrgList, "None", context);                     
                        break;
                    case "Providers":
                        //Lookup and Map the Provider Care Sites
                        var ppmsRelatedProviders = context.AccountSet.Where(i => i.ParentAccountId.Id == ppmsProvider.Id);
                        var ppmsRelatedProvidersList = ppmsRelatedProviders.ToList();
                        if (ppmsRelatedProvidersList.Any())
                        {
                            //Map Providers
                            provider.Providers = await ProviderMap.MapProviders(ppmsRelatedProvidersList, "None", context);
                        }
                        break;
                    case "CareSites":
                        //Lookup and Map the Provider Care Sites
                        var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_organization.Id == ppmsProvider.Id);
                        var ppmsCareSitesList = ppmsCareSites.ToList();
                        if (ppmsCareSitesList.Any())
                        {
                            //Map Care Sites
                            provider.CareSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                        }
                        break;
                    case "DEAs":
                        //Lookup and Map the Provider Care Sites
                        var ppmsDEAs = context.ppms_deascheduleprivilegeSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsDEAsList = ppmsDEAs.ToList();
                        if (ppmsDEAsList.Any())
                        {
                            //Map DEAs
                            provider.DEAs = await DeaMap.MapDea(ppmsDEAsList, "None", context);
                        }
                        break;
                    case "VaProviderRelationships":
                        //Lookup and Map the Va provider relationships
                        var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                        var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                        if (ppmsVaProviderRelationshipsList.Any())
                        {
                            //Map Va Provider Relationships
                            provider.VaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        }
                        break;
                    default:
                        break;
                }

                providerList.Add(provider);
            }

            var prov = providerList.AsQueryable();
            return prov;
        }

    }
}